using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    // Koristimo long.MaxValue da oznacimo da nema viseg elementa u tom smeru
    const long INF_DIST = long.MaxValue; 

    // Struktura za cuvanje svih podataka o tacki
    public class JarbolData
    {
        public int OriginalIndex { get; set; }
        public long X { get; set; }
        public long H { get; set; }
        public long DistanceLeft { get; set; } = INF_DIST;
        public long DistanceRight { get; set; } = INF_DIST;
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        long[] x_input = Console.ReadLine().Split().Select(long.Parse).ToArray();
        long[] h_input = Console.ReadLine().Split().Select(long.Parse).ToArray();

        List<JarbolData> jarboli = new List<JarbolData>();
        for (int i = 0; i < n; i++)
        {
            jarboli.Add(new JarbolData { OriginalIndex = i, X = x_input[i], H = h_input[i] });
        }

        // Sortiramo jarbole po X koordinati
        var sortedJarboli = jarboli.OrderBy(p => p.X).ToList();

        // Nema potrebe za kompleksnim Levo/Desno funkcijama.
        // Logika se mora implementirati efikasno (obicno Stack algoritam za O(N), 
        // ali za manje N rucna iteracija je ok)

        // Ipak, rucna iteracija za "prvi visi element" je O(N^2) sto je sporo za 10^9 koordinata. 
        // Problem je algoritam, ne C# sintaksa.

        // Privremeno resenje sa rucnom O(N^2) proverom:
        for (int i = 0; i < n; i++)
        {
            // Provera levo
            for (int j = i - 1; j >= 0; j--)
            {
                if (sortedJarboli[j].H >= sortedJarboli[i].H)
                {
                    // Udaljenost izmedju vrhova je apsolutna razlika X koordinata
                    sortedJarboli[i].DistanceLeft = sortedJarboli[i].X - sortedJarboli[j].X;
                    break;
                }
            }
            // Provera desno
            for (int j = i + 1; j < n; j++)
            {
                if (sortedJarboli[j].H >= sortedJarboli[i].H)
                {
                    sortedJarboli[i].DistanceRight = sortedJarboli[j].X - sortedJarboli[i].X;
                    break;
                }
            }
        }

        // Vracamo rezultate u originalni redosled pomocu privremenog niza
        long[] output = new long[n];
        foreach (var jarbol in sortedJarboli)
        {
            long minDist = Math.Min(jarbol.DistanceLeft, jarbol.DistanceRight);
            
            if (minDist >= INF_DIST)
            {
                output[jarbol.OriginalIndex] = -1; // Nema viseg dela
            }
            else
            {
                output[jarbol.OriginalIndex] = minDist;
            }
        }

        // Ispis rezultata
        foreach (long res in output)
        {
            Console.WriteLine(res);
        }
    }
}